% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_genius_song_lyrics.R
\name{get_genius_song_lyrics}
\alias{get_genius_song_lyrics}
\title{Get Song Lyrics}
\usage{
get_genius_song_lyrics(song_id, output = "tibble", url = NULL,
  access_token = Sys.getenv("GENIUS_API_TOKEN"))
}
\arguments{
\item{song_id}{Genius Song ID}

\item{output}{'tibble' or 'text'. Default: tibble.}

\item{url}{If for some reason the function cannot find the url to download the letter, you can use a genius url to download it.}

\item{access_token}{Genius Web API token. Defaults to Sys.getenv('GENIUS_API_TOKEN').}
}
\value{
Returns a tibble or a character vector with the lyrics
}
\description{
This function gets the lyrics of the desired song.
}
\details{
To use this function, you need to first use 'search_genius_song' to get the song ID.
}
\examples{
\dontrun{
get_genius_song_lyrics('55882', output = 'text')
}
}
\author{
Alberto Almuiña
}
