% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geomorphon.R
\name{geomorphon_categories}
\alias{geomorphon_categories}
\alias{geomorphon_colors}
\alias{geomorphon_theme}
\title{Apply Geomorphon Theme to Result Object}
\usage{
geomorphon_categories()

geomorphon_colors()

geomorphon_theme(x, forms = "forms10")
}
\arguments{
\item{x}{A SpatRaster or matrix object.}

\item{forms}{character. One of: \code{"forms10"} (default), \code{"forms6"},
\code{"forms5"}, \code{"forms4"}. These are themes corresponding to the built-in
10-form, 6-form, 5-form, and 4-form \verb{"forms}" outputs from \code{\link[=geomorphons]{geomorphons()}}.}
}
\value{
A SpatRaster or matrix object with geomorphon class names (and colors
for SpatRaster) applied.
}
\description{
Applies standard class names and colors to a SpatRaster, or creates a factor
matrix. Input values should be integers between 1 and 10.
}
\details{
When \code{x} is a matrix the result is a factor using \code{geomorphon_categories()}.
Values are integers 1 to 10 and labels are the geomorphon form names.
}
\examples{

geomorphon_theme(1:10)

}
