% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gads_get_ad_groups.R
\name{gads_get_ad_groups}
\alias{gads_get_ad_groups}
\title{Get Ad Groups Dictionary From Google Ads Client Account}
\usage{
gads_get_ad_groups(
  customer_id = getOption("gads.customer.id"),
  fields = c("ad_group.id", "ad_group.name", "ad_group.status",
    "ad_group.ad_rotation_mode", "ad_group.base_ad_group", "ad_group.campaign",
    "campaign.id", "ad_group.display_custom_bid_dimension",
    "ad_group.effective_target_cpa_source", "ad_group.effective_target_roas",
    "ad_group.effective_target_roas_source", "ad_group.final_url_suffix",
    "ad_group.target_roas", "ad_group.type", "ad_group.url_custom_parameters",
    "ad_group.tracking_url_template", "customer.id", "customer.descriptive_name"),
  where = NULL,
  order_by = NULL,
  limit = NULL,
  parameters = NULL,
  login_customer_id = getOption("gads.login.customer.id"),
  include_resource_name = FALSE,
  cl = NULL,
  verbose = TRUE
)
}
\arguments{
\item{customer_id}{Google Ads client customer id, supports a single account id: "xxx-xxx-xxxx" or a vector of ids from the same Google Ads MCC: c("xxx-xxx-xxxx", "xxx-xxx-xxxx")}

\item{fields}{character vector, list of report fields, all report has own fields list, for example \href{https://developers.google.com/google-ads/api/fields/v10/ad_group}{see field list of ad group report}.}

\item{where}{Filter, for example you can filter campaigns by status \code{where = "campaign.status = 'ENABLED'"}.}

\item{order_by}{Sorting, character vectors of fields and sorting directions, for example \code{order_by = c("campaign.name DESC", "metrics.clicks")}.}

\item{limit}{Maximun rows in report}

\item{parameters}{Query parameters, for example \code{parameters = "include_drafts=true"}.}

\item{login_customer_id}{Google Ads manager customer id}

\item{include_resource_name}{Get resource names fields in report}

\item{cl}{A cluster object created by \code{\link{makeCluster}}, or an integer to indicate number of child-processes (integer values are ignored on Windows) for parallel evaluations (see Details on performance).}

\item{verbose}{Console log output}
}
\value{
tibble with ad group dicrionary
}
\description{
Get Ad Groups Dictionary From Google Ads Client Account
}
\examples{
\dontrun{
# set client customer id
gads_set_login_customer_id('xxx-xxx-xxxx')

# set manager id if you work under MCC
gads_set_customer_id('xxx-xxx-xxxx')

# load ad groups list
adgroups <- gads_get_ad_groups(
    where = 'ad_group.status = "ENABLED"'
)

}
}
\seealso{
\href{https://developers.google.com/google-ads/api/fields/v10/ad_group_query_builder}{Google Ads Query Builder}
}
