% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{mapedge}
\alias{mapedge}
\title{Function to quickly draft the edge of the equirectangular projection}
\usage{
mapedge(
  x = 360,
  y = 180,
  xmin = -180,
  xmax = 180,
  ymin = -90,
  ymax = 90,
  out = "sf",
  crs = "EPSG:4326"
)
}
\arguments{
\item{x}{(\code{numeric}) Number of segments in the x (longitude) dimension.}

\item{y}{(\code{numeric}) Number of segments in the y (latitude) dimension.}

\item{xmin}{(\code{numeric}) Minimum value of x (longitude).}

\item{xmax}{(\code{numeric}) Minimum value of x (longitude).}

\item{ymin}{(\code{numeric}) Maximum value of y (latitude).}

\item{ymax}{(\code{numeric}) Maximum value of y (latitude).}

\item{out}{(\code{character}) Output format, either \code{"sf"} or \code{"sp"}. The default \code{"sf"} returns simple feature geometries, \code{"sp"} returns \code{SpatialPolygons} from the \code{sp} package.}

\item{crs}{(\code{character}) Coordinate Reference System of the returned spatial object given as a character string, defaults to \code{"EPSG:4326"} (WGS 84). Can be used to project the map edge immedately after creating it. Takes effect only if \code{sf=TRUE} or \code{sp=TRUE}.}
}
\value{
An \code{sfc}-, or \code{SpatialPolygons}-class object.
}
\description{
Function to plot the edge of a map with different projections.
}
\examples{
# requires rgdal
edge <- mapedge()
molledge <- st_transform(edge, "ESRI:54009")
plot(molledge) 

}
