% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor_fields.R
\name{ricci}
\alias{ricci}
\title{Ricci curvature tensor}
\usage{
ricci(g)
}
\arguments{
\item{g}{A covariant metric tensor, a "metric_field" object. See \code{\link[=metric_field]{metric_field()}}
to create a new metric tensor, or use predefined metrics,
e.g. \code{\link[=g_eucl_cart]{g_eucl_cart()}}.}
}
\value{
Returns the covariant Ricci curvature tensor \eqn{R_{ij}}
as rank 2 \code{\link[=array]{array()}}.
}
\description{
Provides the covariant Ricci curvature tensor \eqn{R_{ij}=R^{s}_{i s j}}.
}
\examples{
ricci(g_eucl_sph(3))
}
\seealso{
Wikipedia: \href{https://en.wikipedia.org/wiki/Riemann_curvature_tensor#Ricci_curvature}{Ricci curvature tensor}

Other geometric tensors: 
\code{\link{christoffel}()},
\code{\link{ricci_sc}()},
\code{\link{riemann}()}
}
\concept{geom_tensors}
\concept{geometric tensors}
