% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor.R
\name{simplify}
\alias{simplify}
\title{Simplify symbolic expressions}
\usage{
simplify(x)
}
\arguments{
\item{x}{A character \code{\link[=array]{array()}} or \code{\link[=tensor]{tensor()}} consisting of mathematical expressions.}
}
\value{
A character \code{\link[=array]{array()}} or \code{\link[=tensor]{tensor()}} of the same form, potentially
with simplified expressions.
}
\description{
Attempts to simplify expressions in an array or tensor.
Non-array objects are coerced to arrays with \code{\link[=as.array]{as.array()}}.
}
\details{
Instead of using an explicit call to \code{simplify()} you also have the option
to enable automatic simplification via \code{option(ricci.auto_simplify = TRUE)}.
Note however that this comes at a significant performance cost.

This operation requires the \href{https://r-cas.github.io/ryacas/}{Ryacas}
package.
}
\examples{
\dontshow{if (requireNamespace("Ryacas", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
simplify("x + y - x")
\dontshow{\}) # examplesIf}
}
\concept{eval}
