% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor_arith.R
\name{Ops.tensor}
\alias{Ops.tensor}
\title{Arithmetic tensor operations}
\usage{
\method{Ops}{tensor}(e1, e2)
}
\arguments{
\item{e1, e2}{Labeled arrays created with \link{\%_\%}.}
}
\value{
A resulting labeled array in case of \code{+}, \code{-}, \code{*}, \code{/}.
\code{TRUE} or \code{FALSE} in case of \code{==}.
}
\description{
Once a labeled array (tensor) has been defined, tensor arithmetic operations
can be carried out with the usual \code{+}, \code{-}, \code{*}, \code{/}, and \code{==} symbols.
}
\section{Addition and Subtraction}{
Addition and subtraction requires the two tensors to have an equal index
structure, i.e. the index names their position and the dimensions
associated to the index names have to agree.
The index order does not matter, the operation will match dimensions
by index name.
}

\section{Multiplication}{
Tensor multiplication takes into account implicit Ricci calculus rules
depending on index placement.
\itemize{
\item Equal-named and opposite-positioned dimensions are contracted.
\item Equal-named and equal-positioned dimensions are subsetted.
\item The result is an outer product for distinct index names.
}
}

\section{Division}{
Division performs element-wise division. If the second argument is a
scalar, each element is simply divided by the scalar.
Similar to addition and subtraction, division requires the two tensors
to have an equal index structure, i.e. the index names their position
and the dimensions associated to the index names have to agree.
}

\section{Equality check}{
A tensor \eqn{a_{i_1 i_2 ...}} is equal to a tensor \eqn{b_{j_1 j_2 ...}} if
and only if the index structure agrees and all components are equal.
}

\examples{
a <- array(1:4, c(2, 2))
b <- array(3 + 1:4, c(2, 2))

# addition
a \%_\% .(i, j) + b \%_\% .(j, i)

# multiplication
a \%_\% .(i, j) * b \%_\% .(+i, k)

# division
a \%_\% .(i, j) / 10

# equality check
a \%_\% .(i, j) == a \%_\% .(i, j)
a \%_\% .(i, j) == a \%_\% .(j, i)
a \%_\% .(i, j) == b \%_\% .(i, j)

# this will err because index structure does not agree
try(a \%_\% .(i, j) == a \%_\% .(k, j))
}
\seealso{
Other tensor operations: 
\code{\link{asym}()},
\code{\link{kron}()},
\code{\link{l}()},
\code{\link{r}()},
\code{\link{subst}()},
\code{\link{sym}()}
}
\concept{arith}
\concept{tensor operations}
