% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor_fields.R
\name{ricci_sc}
\alias{ricci_sc}
\title{Ricci scalar}
\usage{
ricci_sc(g)
}
\arguments{
\item{g}{A covariant metric tensor, a "metric_field" object. See \code{\link[=metric_field]{metric_field()}}
to create a new metric tensor, or use predefined metrics,
e.g. \code{\link[=g_eucl_cart]{g_eucl_cart()}}.}
}
\value{
Returns the Ricci scalar \eqn{R} as single number/expression.
}
\description{
Provides the Ricci scalar \eqn{R}.
}
\examples{
ricci_sc(g_eucl_sph(3))
}
\seealso{
Wikipedia: \href{https://en.wikipedia.org/wiki/Scalar_curvature}{Ricci scalar}

Other geometric tensors: 
\code{\link{christoffel}()},
\code{\link{ricci}()},
\code{\link{riemann}()}
}
\concept{geom_tensors}
\concept{geometric tensors}
