% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_inat_taxon_stats.R
\name{get_inat_taxon_stats}
\alias{get_inat_taxon_stats}
\title{Get stats on taxon counts}
\usage{
get_inat_taxon_stats(
  date = NULL,
  date_range = NULL,
  place = NULL,
  project = NULL,
  uid = NULL
)
}
\arguments{
\item{date}{Retrieve observations on a specific date. Must be a string in the form "YYYY-MM-DD".}

\item{date_range}{A vector of two dates defining a date range, each in the form "YYYY-MM-DD".}

\item{place}{Get taxon stats by place. You can find place IDs on the \href{https://www.inaturalist.org/places}{iNaturalist website}. Must be a numeric ID.}

\item{project}{Get taxon stats by a project's numeric ID.}

\item{uid}{Get taxon stats by user ID (string).}
}
\value{
A vector listing counts of observations at each level of identification possible (species, genus, etc.)
}
\description{
Get stats on taxa within a constrained range. This range can be by user, place, project, day or date range. Output will be a count of the total number of taxa observed at each taxonomic level.
}
\examples{
\dontrun{
 counts <- get_inat_taxon_stats(date = "2010-06-14")
}
}
