% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.R
\name{alignFactors}
\alias{alignFactors}
\alias{alignFactors.liger}
\alias{alignFactors.Seurat}
\title{Align factor loadings to get final integration}
\usage{
alignFactors(object, method = c("quantileNorm", "centroidAlign"), ...)

\method{alignFactors}{liger}(object, method = c("quantileNorm", "centroidAlign"), ...)

\method{alignFactors}{Seurat}(object, method = c("quantileNorm", "centroidAlign"), ...)
}
\arguments{
\item{object}{A \linkS4class{liger} or Seurat object with valid factorization
result available (i.e. \code{\link{runIntegration}} performed in advance).}

\item{method}{Character, method to align factors. Default
\code{"centroidAlign"}. Optionally \code{"quantileNorm"}.}

\item{...}{Additional arguments passed to selected methods.
For \code{"quantileNorm"}:
\describe{
\item{\code{quantiles}}{Number of quantiles to use for quantile
normalization. Default \code{50}.}
\item{\code{reference}}{Character, numeric or logical selection of one
dataset, out of all available datasets in \code{object}, to use as a
"reference" for quantile normalization. Default \code{NULL} tries to find
an RNA dataset with the largest number of cells; if no RNA dataset
available, use the globally largest dataset.}
\item{\code{minCells}}{Minimum number of cells to consider a cluster
shared across datasets. Default \code{20}.}
\item{\code{nNeighbors}}{Number of nearest neighbors for within-dataset
knn graph. Default \code{20}.}
\item{\code{useDims}}{Indices of factors to use for shared nearest factor
determination. Default \code{NULL} uses all factors.}
\item{\code{center}}{Whether to center the data when scaling factors.
Could be useful for less sparse modalities like methylation data.
Default \code{FALSE}.}
\item{\code{maxSample}}{Maximum number of cells used for quantile
normalization of each cluster and factor. Default \code{1000}.}
\item{\code{eps}}{The error bound of the nearest neighbor search. Lower
values give more accurate nearest neighbor graphs but take much longer to
compute. Default \code{0.9}.}
\item{\code{refineKNN}}{Whether to increase robustness of cluster
assignments using KNN graph. Default \code{TRUE}.}
\item{\code{clusterName}}{Variable name that will store the clustering
result in metadata of a \linkS4class{liger} object or a \code{Seurat}
object. Default \code{"quantileNorm_cluster"}.}
\item{\code{seed}}{Random seed to allow reproducible results. Default
\code{1}.}
\item{\code{verbose}}{Logical. Whether to show information of the
progress. Default \code{getOption("ligerVerbose")} or \code{TRUE} if
users have not set.}
}
For \code{"centroidAlign"} \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}:
\describe{
\item{\code{lambda}}{Ridge regression penalty applied to each dataset.
Can be one number that applies to all datasets, or a numeric vector with
length equal to the number of datasets. Default \code{1}.}
\item{\code{useDims}}{Indices of factors to use considered for the
alignment. Default \code{NULL} uses all factors.}
\item{\code{scaleEmb}}{Logical, whether to scale the factor loading being
considered as the embedding. Default \code{TRUE}.}
\item{\code{centerEmb}}{Logical, whether to center the factor loading
being considered as the embedding before scaling it. Default \code{TRUE}.}
\item{\code{scaleCluster}}{Logical, whether to scale the factor loading
being considered as the cluster assignment probability. Default
\code{FALSE}.}
\item{\code{centerCluster}}{Logical, whether to center the factor loading
being considered as the cluster assignment probability before scaling it.
Default \code{FALSE}.}
\item{\code{shift}}{Logical, whether to shift the factor loading being
considered as the cluster assignment probability after centered scaling.
Default \code{FALSE}.}
\item{\code{diagnosis}}{Logical, whether to return cell metadata variables
with diagnostic information. Default \code{FALSE}.}
}}
}
\description{
This function is a wrapper to switch between alternative factor loading
alignment methods that LIGER provides, which is a required step for producing
the final integrated result. Two methods are provided (click on options for
more details):

\itemize{
\item{\code{method = "\link{quantileNorm}"}: Previously published quantile
normalization method. (default)}
\item{\code{method = "\link{centroidAlign}"}: Newly developed centroid
alignment method. \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}}
}
}
\seealso{
\code{\link{quantileNorm}}, \code{\link{centroidAlign}}
}
