% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clip_erase.R
\name{ms_erase}
\alias{ms_erase}
\title{Remove features or portions of features that fall inside a specified area}
\usage{
ms_erase(target, erase = NULL, bbox = NULL, remove_slivers = FALSE, ...)
}
\arguments{
\item{target}{the target layer from which to remove portions. One of:
\itemize{
\item \code{geo_json} or \code{character} points, lines, or polygons;
\item \code{SpatialPolygons}, \code{SpatialLines}, \code{SpatialPoints}
}}

\item{erase}{the erase layer (polygon). One of:
\itemize{
\item \code{geo_json} or \code{character} polygons;
\item \code{SpatialPolygons*}
}}

\item{bbox}{supply a bounding box instead of an erasing layer to remove from
the target layer. Supply as a numeric vector: \code{c(minX, minY, maxX, maxY)}.}

\item{remove_slivers}{Remove tiny sliver polygons created by erasing. (Default \code{FALSE})}

\item{...}{
  Arguments passed on to \code{\link[=apply_mapshaper_commands]{apply_mapshaper_commands}}
  \describe{
    \item{\code{force_FC}}{should the output be forced to be a FeatureCollection (or sf
object or Spatial*DataFrame) even if there are no attributes? Default
\code{TRUE}. If FALSE and there are no attributes associated with the
geometries, a GeometryCollection (or Spatial object with no dataframe, or
sfc) will be output.}
    \item{\code{sys}}{Should the system mapshaper be used instead of the bundled
mapshaper? Gives better performance on large files. Requires the mapshaper
node package to be installed and on the PATH.}
    \item{\code{sys_mem}}{How much memory (in GB) should be allocated if using the
system mapshaper (\code{sys = TRUE})? Default 8. Ignored if \code{sys = FALSE}. This
can also be set globally with the option \code{"mapshaper.sys_mem"}}
    \item{\code{quiet}}{If \code{sys = TRUE}, should the mapshaper messages be silenced?
Default \code{FALSE}. This can also be set globally with the option
\code{"mapshaper.sys_quiet"}}
    \item{\code{gj2008}}{Generate output that is consistent with the pre-RFC 7946
GeoJSON spec (dating to 2008). Polygon rings are CW and holes are CCW,
which is the opposite of the default RFC 7946-compatible output. This should
be rarely needed, though may be useful when preparing data for D3-based
data visualizations (such as \code{plotly::plot_ly()}). Default \code{FALSE}}
  }}
}
\value{
erased target in the same format as the input target
}
\description{
Removes portions of the target layer that fall inside the erasing layer or bounding box.
}
\examples{
if (rmapshaper:::v8_version() >= "6") {
  library(geojsonsf, quietly = TRUE)
  library(sf)

  points <- structure("{\"type\":\"FeatureCollection\",
    \"features\":[{\"type\":\"Feature\",\"properties\":{},
    \"geometry\":{\"type\":\"Point\",\"coordinates\":
    [52.8658,-44.7219]}},{\"type\":\"Feature\",\"properties\":{},
    \"geometry\":{\"type\":\"Point\",\"coordinates\":
    [53.7702,-40.4873]}},{\"type\":\"Feature\",\"properties\":{},
    \"geometry\":{\"type\":\"Point\",\"coordinates\":[55.3204,-37.5579]}},
    {\"type\":\"Feature\",\"properties\":{},\"geometry\":
    {\"type\":\"Point\",\"coordinates\":[56.2757,-37.917]}},
    {\"type\":\"Feature\",\"properties\":{},\"geometry\":
    {\"type\":\"Point\",\"coordinates\":[56.184,-40.6443]}},
    {\"type\":\"Feature\",\"properties\":{},\"geometry\":
    {\"type\":\"Point\",\"coordinates\":[61.0835,-40.7529]}},
    {\"type\":\"Feature\",\"properties\":{},\"geometry\":
    {\"type\":\"Point\",\"coordinates\":[58.0202,-43.634]}}]}",
    class = c("geojson", "json"))
  points <- geojson_sf(points)
  plot(points)

  erase_poly <- structure('{
  "type": "Feature",
  "properties": {},
  "geometry": {
  "type": "Polygon",
  "coordinates": [
  [
  [51, -40],
  [55, -40],
  [55, -45],
  [51, -45],
  [51, -40]
  ]
  ]
  }
  }', class = c("geojson", "json"))
  erase_poly <- geojson_sf(erase_poly)

  out <- ms_erase(points, erase_poly)
  plot(out, add = TRUE)
}

}
