% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blrm.r
\name{blrmStats}
\alias{blrmStats}
\title{Compute Indexes of Predictive Accuracy and Their Uncertainties}
\usage{
blrmStats(fit, ns = 400, prob = 0.95, pl = FALSE, dist = c("density", "hist"))
}
\arguments{
\item{fit}{an object produced by \code{\link[=blrm]{blrm()}}}

\item{ns}{number of posterior draws to use in the calculations (default is 400)}

\item{prob}{HPD interval probability (default is 0.95)}

\item{pl}{set to \code{TRUE} to plot the posterior densities using base graphics}

\item{dist}{if \code{pl} is \code{TRUE} specifies whether to plot the density estimate (the default) or a histogram}
}
\value{
list of class \code{blrmStats} whose most important element is \code{Stats}.  The indexes computed are defined below, with gp, B, EV, and vp computed using the intercept corresponding to the median value of Y.  See \url{https://fharrell.com/post/addvalue} for more information.
\describe{
\item{"Dxy"}{Somers' Dxy rank correlation between predicted and observed.  The concordance probability (c-index; AUROC in the binary Y case) may be obtained from the relationship Dxy=2(c-0.5).}
\item{"g"}{Gini's mean difference: the average absolute difference over all pairs of linear predictor values}
\item{"gp"}{Gini's mean difference on the predicted probability scale}
\item{"B"}{Brier score}
\item{"EV"}{explained variation}
\item{"v"}{variance of linear predictor}
\item{"vp"}{variable of estimated probabilities}
}
}
\description{
For a binary or ordinal logistic regression fit from \code{\link[=blrm]{blrm()}}, computes several indexes of predictive accuracy along with highest posterior density intervals for them.  Optionally plots their posterior densities.
When there are more than two levels of the outcome variable, computes Somers' Dxy and c-index on a random sample of 10,000 observations.
}
\examples{
\dontrun{
  f <- blrm(...)
  blrmStats(f, pl=TRUE)   # print and plot
}
}
\seealso{
\code{\link[Hmisc:rcorr.cens]{Hmisc::rcorr.cens()}}
}
\author{
Frank Harrell
}
