% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robomit_functions.R
\name{o_delta_boot_viz}
\alias{o_delta_boot_viz}
\title{Visualization of bootstrapped delta*s}
\usage{
o_delta_boot_viz(y, x, con, w = NULL, id = "none", time = "none",
beta = 0, R2max, sim, obs, rep, CI, type, norm = TRUE, bin,
col = c("#08306b","#4292c6","#c6dbef"), nL = TRUE, mL = TRUE, useed = NA, data)
}
\arguments{
\item{y}{Name of the dependent variable (as string).}

\item{x}{Name of the independent treatment variable (i.e., variable of interest; as string).}

\item{con}{Name of related control variables. Provided as string in the format: "w + z +...".}

\item{w}{weights (only for weighted estimations). Warning: For weighted panel models R can report different R-square than Stata, leading deviation between R and Stata results.}

\item{id}{Name of the individual id variable (e.g. firm or farm; as string). Only applicable for fixed effect panel models.}

\item{time}{Name of the time id variable (e.g. year or month; as string). Only applicable for fixed effect panel models.}

\item{beta}{beta for which delta*s should be estimated (default is beta = 0).}

\item{R2max}{Maximum R-square for which delta*s should be estimated.}

\item{sim}{Number of simulations.}

\item{obs}{Number of draws per simulation.}

\item{rep}{Bootstrapping either with (= TRUE) or without (= FALSE) replacement}

\item{CI}{Confidence intervals, indicated as vector. Can be and/or 90, 95, 99.}

\item{type}{Model type (either \emph{lm} or \emph{plm}; as string).}

\item{norm}{Option to include a normal distribution in the plot (default is norm = TURE).}

\item{bin}{Number of bins used in the histogram.}

\item{col}{Colors used to indicate different confidence interval levels (indicated as vector). Needs to be the same length as the variable CI. The default is a blue color range.}

\item{nL}{Option to include a red vertical line at 0 (default is nL = TRUE).}

\item{mL}{Option to include a vertical line at beta* mean (default is mL = TRUE).}

\item{useed}{User defined seed.}

\item{data}{Dataset.}
}
\value{
Returns ggplot2 object, which depicts the bootstrapped delta*s.
}
\description{
Estimates and visualizes bootstrapped delta*s, i.e., the degree of selection on unobservables relative to observables (with respect to the treatment variable) that would be necessary to eliminate the result (following Oster 2019).
}
\details{
Estimates and visualizes bootstrapped delta*s, i.e., the degree of selection on unobservables relative to observables (with respect to the treatment variable) that would be necessary to eliminate the result (following Oster 2019). Bootstrapping can either be done with or without replacement. The function supports linear cross-sectional (see \emph{lm} objects in R) and fixed effect panel (see \emph{plm} objects in R) models.
}
\examples{
# load data, e.g. the in-build mtcars dataset
data("mtcars")
data_oster <- mtcars

# preview of data
head(data_oster)

# load robomit
require(robomit)

# estimate and visualize bootstrapped delta*s
o_delta_boot_viz(y = "mpg",           # dependent variable
                 x = "wt",            # independent treatment variable
                 con = "hp + qsec",   # related control variables
                 beta = 0,            # beta
                 R2max = 0.9,         # maximum R-square
                 sim = 100,           # number of simulations
                 obs = 30,            # draws per simulation
                 rep = FALSE,         # bootstrapping with or without replacement
                 CI = c(90,95,99),    # confidence intervals
                 type = "lm",         # model type
                 norm = TRUE,         # normal distribution
                 bin = 200,           # number of bins
                 useed = 123,         # seed
                 data = data_oster)   # dataset
}
\references{
Oster, E. (2019). Unobservable Selection and Coefficient Stability: Theory and Evidence. Journal of Business & Economic Statistics, 37, 187-204.
}
