test_that("examples run (sampled)", {
  skip_on_cran()
  db <- tryCatch(
    tools::Rd_db("robustfa"),
    error = function(e) testthat::skip(paste("docs unavailable/corrupt:", conditionMessage(e)))
  )
  topics <- unique(unlist(lapply(db, function(rd) tools:::.Rd_get_metadata(rd, "alias"))))
  set.seed(1)
  topics <- unique(topics[!topics %in% c("NULL", "robustfa")])
  topics <- head(topics, 8)
  for (tp in topics) {
    expect_error(
      utils::example(topic = tp, package = "robustfa", ask = FALSE, run.dontrun = FALSE, run.donttest = FALSE),
      NA,
      info = paste("example failed for", tp)
    )
  }
})
