% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_source_from_gDocs.R
\name{import_source_from_gDocs}
\alias{import_source_from_gDocs}
\title{Import a source from Google Documents}
\usage{
import_source_from_gDocs(x, localFile = NULL)
}
\arguments{
\item{x}{The URL to the source: has to be viewable publicly!}

\item{localFile}{A local file (where to store a local backup).}
}
\value{
The source contents.
}
\description{
Import a source from Google Documents
}
\examples{
### Note that this will require an active
### internet connection! This if statement
### checks for that.
\donttest{
if (tryCatch({readLines("https://google.com",n=1); TRUE}, error=function(x) FALSE)) {

  gDocs_url <-
    paste0(
      "https://docs.google.com/document/d/",
      "1iACYjV7DdCjOmfgX6KEMtCcCjuuXD3iuikTSGWtsK84",
      "/edit?usp=sharing"
    );

  ### Import the source
  exampleSource <-
    import_source_from_gDocs(
      gDocs_url
    );

  ### Show the downloaded file:
  exampleSource;

  ### Parse the source:
  parsedExampleSource <-
    rock::parse_source(
      exampleSource
    );

  ### Imported; the comments are gone:
  parsedExampleSource$qdt$utterances_raw;
}
}
}
