% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.roclearn.R
\name{cv.roclearn}
\alias{cv.roclearn}
\title{Cross-validation for linear models}
\usage{
cv.roclearn(
  X,
  y,
  lambda.vec = NULL,
  lambda.length = 30,
  penalty = "ridge",
  param.penalty = NULL,
  loss = "hinge",
  approx = NULL,
  intercept = TRUE,
  nfolds = 10,
  target.perf = list(),
  param.convergence = list()
)
}
\arguments{
\item{X}{Predictor matrix or data.frame (categorical variables are
automatically one-hot encoded).}

\item{y}{Response vector with class labels in \{-1, 1\}. Labels given as
\{0, 1\} or as a two-level factor/character are automatically converted
to this format.}

\item{lambda.vec}{Optional numeric vector of regularization parameters (lambda values).
If \code{NULL} (default), a decreasing sequence is generated automatically.}

\item{lambda.length}{Number of \eqn{\lambda} values to generate if
\code{lambda.vec} is \code{NULL}. Default is 30.}

\item{penalty}{Regularization penalty type: \code{"ridge"} (default), \code{"lasso"},
\code{"elastic"}, \code{"alasso"}, \code{"scad"}, or \code{"mcp"}.}

\item{param.penalty}{Penalty-specific parameter:
\itemize{
\item Ignored for \code{"ridge"} and \code{"lasso"}.
\item Mixing parameter \eqn{\alpha \in (0,1)} for \code{"elastic"}. Default is 0.5.
\item Adaptive weight exponent \eqn{\gamma > 0} for \code{"alasso"}. Default is 1.
\item Tuning parameter (default 3.7) for \code{"scad"} and \code{"mcp"}.
}}

\item{loss}{Surrogate loss function type. One of:
\code{"hinge"} (default), \code{"hinge2"} (squared hinge),
\code{"logistic"}, or \code{"exponential"}.}

\item{approx}{Logical; enables a scalable approximation to accelerate training.
The default is \code{TRUE} when \code{nrow(X) >= 1000}, and \code{FALSE} otherwise.
For details about how approximation is applied, see the \code{details}
section of the \code{roclearn} function.}

\item{intercept}{Logical; include an intercept in the model (default \code{TRUE}).}

\item{nfolds}{Number of cross-validation folds (default 10).}

\item{target.perf}{List with target sensitivity and specificity used when
estimating the intercept (defaults to 0.9 each).}

\item{param.convergence}{List of convergence controls (e.g., \code{maxiter},
\code{eps}). Default is \code{list(maxiter = 5e4, eps = 1e-4)}.}
}
\value{
An object of class \code{"cv.roclearn"} with:
\itemize{
\item \code{optimal.lambda} — selected \eqn{\lambda}.
\item \code{optimal.fit} — model refit on the full data at
\code{optimal.lambda}.
\item \code{lambda.vec} — grid of penalty values considered.
\item \code{auc.mean}, \code{auc.sd} — mean and sd of cross-validated AUC.
\item \code{auc.result} — fold-by-lambda AUC matrix.
\item \code{time.mean}, \code{time.sd} — mean and sd of training time.
\item \code{time.result} — fold-by-lambda training time matrix.
\item \code{nfolds}, \code{loss}, \code{penalty} — settings.
}
}
\description{
Perform k-fold cross-validation over a sequence of \eqn{\lambda} values and
select the optimal model based on AUC.
}
\examples{
set.seed(123)
n <- 100
n_pos <- round(0.2 * n)
n_neg <- n - n_pos

X <- rbind(
  matrix(rnorm(2 * n_neg, mean = -1), ncol = 2),
  matrix(rnorm(2 * n_pos, mean =  1), ncol = 2)
)
y <- c(rep(-1, n_neg), rep(1, n_pos))

cvfit <- cv.roclearn(
  X, y,
  lambda.vec = exp(seq(log(0.01), log(5), length.out = 3)),
  approx=TRUE, nfolds = 2
)
cvfit$optimal.lambda
}
\seealso{
\code{\link{roclearn}}
}
