% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rocrate.R
\name{rocrate_5s}
\alias{rocrate_5s}
\title{Create a new 5 Safes RO-Crate object}
\usage{
rocrate_5s(
  ...,
  context = "https://w3id.org/ro/crate/1.2/context",
  conformsTo = gsub("\\\\/context$", "\\\\1", context),
  datePublished = Sys.Date(),
  description = "",
  license = "http://spdx.org/licenses/CC-BY-4.0",
  name = "",
  v5scrate = 0.4
)
}
\arguments{
\item{...}{Optional entities to include in the RO-Crate (e.g., author).}

\item{context}{String with URL to the version of the RO-Crate specification
to use. The context brings the defined terms into the metadata document
(default: https://w3id.org/ro/crate/1.2/context).}

\item{conformsTo}{String with URL to the version of the RO-Crate
specification which this object conforms to. Conformance declares which
RO-Crate conventions of using those terms are being followed
(default: URL formed by \code{context}/context)}

\item{datePublished}{String (or Date object) with the date in which the
RO-Crate was published (default: current date).}

\item{description}{String with description for the root entity (default:
empty string).}

\item{license}{String with URL (permalinks are preferred, but not required)
to license to be used for the overall RO-Crate. See the following
resources for license choices:
\url{https://spdx.org/licenses} and/or
\url{https://github.com/spdx/license-list-data/tree/main/jsonld}
(default: CC-BY-4.0: Creative Commons Attribution 4.0 International).}

\item{name}{String with a name/title for the root entity (default: empty
string).}

\item{v5scrate}{Numeric value with the version of the 5 Safes RO-Crate
profile to use.}
}
\value{
5 Safes RO-Crate object, list with an additional class, \code{rocrate}.
}
\description{
Create a new 5 Safes RO-Crate object. This object includes basic skeleton
for the RO-Crate metadata descriptor (\code{ro-crate-metadata.json}) file, as
described in the official documentation: https://w3id.org/ro/crate/1.2 >
\href{https://www.researchobject.org/ro-crate/specification/1.2/root-data-entity.html}{Root Data Entity}.
Additionally, it includes a profile for the 5 Safes RO-Crate:
https://w3id.org/5s-crate/0.4
}
\examples{
rocrateR::rocrate_5s()
}
