% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schemas.R
\name{define_dimension}
\alias{define_dimension}
\alias{define_dimension.star_schema}
\title{Define dimension in a \code{star_schema} object.}
\usage{
define_dimension(
  schema,
  dimension,
  name,
  attributes,
  scd_nk,
  scd_t0,
  scd_t1,
  scd_t2,
  scd_t3,
  scd_t6,
  is_when,
  ...
)

\method{define_dimension}{star_schema}(
  schema,
  dimension = NULL,
  name = NULL,
  attributes = NULL,
  scd_nk = NULL,
  scd_t0 = NULL,
  scd_t1 = NULL,
  scd_t2 = NULL,
  scd_t3 = NULL,
  scd_t6 = NULL,
  is_when = FALSE,
  ...
)
}
\arguments{
\item{schema}{A \code{star_schema} object.}

\item{dimension}{A \code{dimension_schema} object.}

\item{name}{A string, name of the dimension.}

\item{attributes}{A vector of attribute names.}

\item{scd_nk}{A vector of attribute names, scd natural key.}

\item{scd_t0}{A vector of attribute names, scd T0 attributes.}

\item{scd_t1}{A vector of attribute names, scd T1 attributes.}

\item{scd_t2}{A vector of attribute names, scd T2 attributes.}

\item{scd_t3}{A vector of attribute names, scd T3 attributes.}

\item{scd_t6}{A vector of attribute names, scd T6 attributes.}

\item{is_when}{A boolean, is when dimension.}

\item{...}{When dimension configuration parameters.}
}
\value{
A \code{star_schema} object.
}
\description{
Dimensions are part of a \code{star_schema} object. They can be defined directly
as a \code{dimension_schema} object or giving the name and a set of attributes.
}
\examples{

s <- star_schema() |>
  define_dimension(
    name = "when",
    attributes = c(
      "Week Ending Date",
      "WEEK",
      "Year"
    )
  )

s <- star_schema()
d <- dimension_schema(
  name = "when",
  attributes = c(
    "Week Ending Date",
    "WEEK",
    "Year"
  )
)
s <- s |>
  define_dimension(d)
}
\seealso{
\code{\link{star_database}}

Other star schema definition functions: 
\code{\link{define_facts}()},
\code{\link{dimension_schema}()},
\code{\link{fact_schema}()},
\code{\link{star_schema}()}
}
\concept{star schema definition functions}
