% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_generation.R
\name{join_info}
\alias{join_info}
\title{Join unit-level information to a long-format rollout schedule}
\usage{
join_info(
  long_schedule,
  unit_info,
  by = NULL,
  uncount_vars = NULL,
  .ids = NULL
)
}
\arguments{
\item{long_schedule}{A long-format schedule (output from \code{pivot_schedule_longer}).}

\item{unit_info}{A data frame with unit-level information to join.}

\item{by}{Columns used to join \code{long_schedule} and \code{unit_info} (default \code{NULL} uses shared columns).}

\item{uncount_vars}{Optional character vector or list of quosures indicating count variables to expand rows.}

\item{.ids}{Optional character vector specifying names of id columns when uncounting, one per \code{uncount_var}.}
}
\value{
A \code{tibble} with joined and optionally expanded rows to reflect unit counts.
}
\description{
Merges unit-level characteristics or parameters into a long-format rollout schedule and optionally expands rows
based on count variables to create multiple units per site.
}
\examples{
schedule <- tibble::tibble(site = "A", cohort = 1, chron_time = 0, condition = "control")
unit_info <- tibble::tibble(site = "A", n_units = 3)
join_info(schedule, unit_info, by = "site", uncount_vars = "n_units")
}
