% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_rosario.R
\name{plot_rosario}
\alias{plot_rosario}
\title{Diagram of ROSARIO null-model randomizations}
\usage{
plot_rosario(numvec, normalize = TRUE, cols = 4)
}
\arguments{
\item{numvec}{Numeric vector representing a single biological identity'
distribution across ordered time intervals.}

\item{normalize}{Logical; if TRUE (default) scale each half to sum to 1
(compare shapes, not totals).}

\item{cols}{Integer; number of panels (hypothetical distributions) per row.}
}
\value{
Invisibly, a list with:
\itemize{
\item \code{variants} — the original list from \code{rosario(numvec)}
\item \code{mat2k_plotted} — matrix of the plotted variants (min(10, n) × 2k)
\item \code{k} — number of time bins
\item \code{indices_plotted} — which variant indices (1..m) were drawn
}
}
\description{
Visualizes the first 10 hypothetical time use distributions produced by
\code{\link[=rosario]{rosario()}} for a single biological identity. Each panel displays one
hypothetical time use distribution with its cyclic shift shown in dark gray
and its mirror image shown in dark red.
}
\examples{
one <- c(0,5,0,7,5,13,70,0)
plot_rosario(one, cols = 4)

}
