% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/instrumental.variable.reg.R
\name{roseRF_pliv}
\alias{roseRF_pliv}
\title{ROSE random forest estimator for the partially linear instrumental variable model}
\usage{
roseRF_pliv(
  y_formula,
  y_learner,
  y_pars = list(),
  x_formula,
  x_learner,
  x_pars = list(),
  IV1_formula = NA,
  IV1_learner = NA,
  IV1_pars = list(),
  IV2_formula = NA,
  IV2_learner = NA,
  IV2_pars = list(),
  IV3_formula = NA,
  IV3_learner = NA,
  IV3_pars = list(),
  IV4_formula = NA,
  IV4_learner = NA,
  IV4_pars = list(),
  IV5_formula = NA,
  IV5_learner = NA,
  IV5_pars = list(),
  data,
  K = 5,
  S = 1,
  max.depth = 10,
  num.trees = 500,
  min.node.size = max(10, ceiling(0.01 * (K - 1)/K * nrow(data))),
  replace = TRUE,
  sample.fraction = 0.8
)
}
\arguments{
\item{y_formula}{a two-sided formula object describing the regression model for \eqn{\mathbb{E}[Y|Z]}.}

\item{y_learner}{a string specifying the regression method to fit the regression of \eqn{Y} on \eqn{Z} as given by \code{y_formula} (e.g. \code{randomforest, xgboost, neuralnet, gam}).}

\item{y_pars}{a list containing hyperparameters for the \code{y_learner} chosen. Default is an empty list, which performs hyperparameter tuning.}

\item{x_formula}{a two-sided formula object describing the regression model for \eqn{\mathbb{E}[X|Z]}.}

\item{x_learner}{a string specifying the regression method to fit the regression of \eqn{X} on \eqn{Z} as given by \code{x_formula} (e.g. \code{randomforest, xgboost, neuralnet, gam}).}

\item{x_pars}{a list containing hyperparameters for the \code{y_learner} chosen. Default is an empty list, which performs hyperparameter tuning.}

\item{IV1_formula}{a two-sided formula object for the model \eqn{\mathbb{E}[V_1(X)|Z]}.}

\item{IV1_learner}{a string specifying the regression method for \eqn{\mathbb{E}[V_1(X)|Z]} estimation.}

\item{IV1_pars}{a list containing hyperparameters for the \code{IV1_learner} chosen.}

\item{IV2_formula}{a two-sided formula object for the model \eqn{\mathbb{E}[V_2|Z]}. Default is no formula / regression (i.e. \eqn{J=1})}

\item{IV2_learner}{a string specifying the regression method for \eqn{\mathbb{E}[V_2(X)|Z]} estimation.}

\item{IV2_pars}{a list containing hyperparameters for the \code{IV2_learner} chosen.}

\item{IV3_formula}{a two-sided formula object for the model \eqn{\mathbb{E}[V_3(X)|Z]}. Default is no formula / regression (i.e. \eqn{J=1}).}

\item{IV3_learner}{a string specifying the regression method for \eqn{\mathbb{E}[V_3(X)|Z]} estimation.}

\item{IV3_pars}{a list containing hyperparameters for the \code{IV3_learner} chosen.}

\item{IV4_formula}{a two-sided formula object for the model \eqn{\mathbb{E}[V_4(X)|Z]}. Default is no formula / regression (i.e. \eqn{J=1})}

\item{IV4_learner}{a string specifying the regression method for \eqn{\mathbb{E}[V_4(X)|Z]} estimation.}

\item{IV4_pars}{a list containing hyperparameters for the \code{IV4_learner} chosen.}

\item{IV5_formula}{a two-sided formula object for the model \eqn{\mathbb{E}[V_5(X)|Z]}. Default is no formula / regression (i.e. \eqn{J=1})}

\item{IV5_learner}{a string specifying the regression method for \eqn{\mathbb{E}[V_5(X)|Z]} estimation.}

\item{IV5_pars}{a list containing hyperparameters for the \code{IV5_learner} chosen.}

\item{data}{a data frame containing the variables for the partially linear model.}

\item{K}{the number of folds used for \eqn{K}-fold cross-fitting. Default is 5.}

\item{S}{the number of repeats to mitigate the randomness in the estimator on the sample splits used for \eqn{K}-fold cross-fitting. Default is 5.}

\item{max.depth}{Maximum depth parameter used for ROSE random forests. Default is 5.}

\item{num.trees}{Number of trees used for a single ROSE random forest. Default is 50.}

\item{min.node.size}{Minimum node size of a leaf in each tree. Default is \code{max(10,ceiling(0.01 (K-1)/K nrow(data)))}.}

\item{replace}{Whether sampling for a single random tree are performed with (bootstrap) or without replacement. Default is \code{TRUE} (i.e. bootstrap).}

\item{sample.fraction}{Proportion of data used for each random tree. Default is 0.8.}
}
\value{
A list containing:
  \describe{
    \item{\code{theta}}{The estimator of \eqn{\theta_0}.}
    \item{\code{stderror}}{Huber robust estimate of the standard error of the \eqn{\theta_0}-estimator.}
    \item{\code{coefficients}}{Table of \eqn{\theta_0} coefficient estimator, standard error, z-value and p-value.}
  }
}
\description{
ROSE random forest estimator for the partially linear instrumental variable model
}
