% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{copy_rosv}
\alias{copy_rosv}
\title{Copy a \{rosv\} object}
\usage{
copy_rosv(x, ...)
}
\arguments{
\item{x}{Object to copy.}

\item{...}{Additional parameters sent to R6's clone method.}
}
\value{
An R6 class object.
}
\description{
Create a copy of \{rosv\} R6 class objects to ensure original is not also updated with
future changes.
}
\details{
Since R6 classes have reference semantics, to escape updating original objects
a clone can be made with this function.
}
\examples{
original_obj <- RosvQuery1$new(name = 'readxl', ecosystem = 'CRAN')
new_obj <- copy_rosv(original_obj)
}
