% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knit_functions.R
\name{render_qtijs}
\alias{render_qtijs}
\title{Render an RMD/xml file or rqti-object as qti xml with QTIJS}
\usage{
render_qtijs(input, preview_feedback = FALSE, ...)
}
\arguments{
\item{input}{(the path to the input Rmd/md/xml document or \link{AssessmentItem},
\link{AssessmentTest}, \link{AssessmentTestOpal}, \link{AssessmentSection} object)}

\item{preview_feedback}{A boolean value; optional. Set \code{TRUE} value to always
display a model feedback (for example, as a model answer). Default is \code{FALSE}.}

\item{...}{required for passing arguments when knitting}
}
\value{
An URL of the corresponding local server to display the rendering
result.
}
\description{
Generates the qti xml file via rmd2xml. The xml is copied into the QTIJS
folder of the package which transforms the xml into HTML. Finally, the HTML
is displayed and the user can have a preview of the exercise or exam.
}
\details{
Requires a running QTIJS server, which can be started with start_server().
When loading the package rqti, a server is started automatically.

The preview is automatically loaded into the RStudio viewer. Alternatively
you  can just open the browser in the corresponding local server which is
displayed when rendering. Since the function is supposed to be called via the
Knit-Button in RStudio, it defaults to the RStudio viewer pane.

Customize knit function in the Rmd file using the following YAML
setting after the word knit \code{knit: rqti::render_qtijs}.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
file <- system.file("exercises/sc1.Rmd", package='rqti')
render_qtijs(file)
\dontshow{\}) # examplesIf}
}
