% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blsd.R
\name{blsd}
\alias{blsd}
\title{Barcode level signal denoising}
\usage{
blsd(
  kmer,
  method = "spearman",
  ...,
  p.adjust = "BH",
  min_kmer_len = 3L,
  min_number = 3L
)
}
\arguments{
\item{kmer}{kmer data returned by \code{\link[=prep_dataset]{prep_dataset()}}.}

\item{method}{A character string indicating which correlation coefficient is
to be used for the test. One of "pearson", "kendall", or "spearman", can be
abbreviated.}

\item{...}{Other arguments passed to \link[stats:cor.test]{cor.test}.}

\item{p.adjust}{Pvalue correction method, a character string. Can be
abbreviated. Details see \link[stats:p.adjust]{p.adjust}.}

\item{min_kmer_len}{An integer, the minimal number of kmer to filter taxa.
SAHMI use \code{2}.}

\item{min_number}{An integer, the minimal number of cell per taxid. SAHMI use
\code{4}.}
}
\value{
A polars \link[polars:DataFrame_class]{DataFrame}
}
\description{
True taxa are detected on multiple barcodes and with a proprotional number of
total and unique k-mer sequences across barcodes, measured as a significant
Spearman correlation between the number of total and unique k-mers across
barcodes. (\code{padj < 0.05})
}
\examples{
\dontrun{
# 1. `sahmi_datasets` should be the output of all samples from 
      `prep_dataset()` 
# 2. `real_taxids_slsd` should be the output of `slsd()`
umi_list <- lapply(sahmi_datasets, function(dataset) {
    # Barcode level signal denoising (barcode k-mer correlation test)
    blsd <- blsd(dataset$kmer)
    real_taxids <- blsd$filter(pl$col("padj")$lt(0.05))$get_column("taxid")
    # only keep taxids pass Sample level signal denoising
    real_taxids <- real_taxids$filter(real_taxids$is_in(real_taxids_slsd))
    # remove contaminants
    real_taxids <- real_taxids$filter(
        real_taxids$is_in(attr(truly_microbe, "truly"))
    )
    # filter UMI data
    dataset$umi$filter(pl$col("taxid")$is_in(real_taxids))
})
}
}
\seealso{
\url{https://github.com/sjdlabgroup/SAHMI}
}
