% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsat_list_data.R
\name{rsat_list_data}
\alias{rsat_list_data}
\alias{rsat_list_data,rtoi-method}
\alias{rsat_list_data,rtoi}
\title{List the information available for an \code{rtoi}}
\usage{
rsat_list_data(x, ...)

\S4method{rsat_list_data}{rtoi}(x, ...)
}
\arguments{
\item{x}{an \code{rtoi} object.}

\item{...}{additional arguments.}
}
\value{
a \code{data.frame} of the available information.
}
\description{
Displays the existing products, bands,
and processing levels for a given \code{rtoi}
}
\examples{
\dontrun{
file.copy(from=system.file("ex/Navarre",package="rsat"),
         to=tempdir(),
         recursive = TRUE)

# load example rtoi
navarre <- read_rtoi(file.path(tempdir(),"Navarre"))

print(navarre)

# print empty rtoi
rsat_list_data(navarre)

file.copy(from=system.file("ex/Pamplona",package="rsat"),
         to=tempdir(),
         recursive = TRUE)

# load example rtoi
pamplona <- read_rtoi(file.path(tempdir(),"Pamplona"))

print(pamplona)

rtoi.data <- rsat_list_data(pamplona)
# print mosaicked bands
print(rtoi.data)

# print mosaicked bands + derived NDVI
file.copy(from=system.file("ex/PamplonaDerived",package="rsat"),
         to=tempdir(),
         recursive = TRUE)

# load example rtoi
pamplona.derived <- read_rtoi(file.path(tempdir(),"PamplonaDerived"))
rsat_list_data(pamplona.derived)
}
}
