% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-functions.R
\name{set_parameters}
\alias{set_parameters}
\title{Define parameters for SPRITE algorithm}
\usage{
set_parameters(
  mean,
  sd,
  n_obs,
  min_val,
  max_val,
  m_prec = NULL,
  sd_prec = NULL,
  n_items = 1,
  restrictions_exact = NULL,
  restrictions_minimum = NULL,
  dont_test = FALSE
)
}
\arguments{
\item{mean}{The mean of the distribution}

\item{sd}{The standard deviation of the distribution}

\item{n_obs}{The number of observations (sample size)}

\item{min_val}{The minimum value}

\item{max_val}{The maximum value}

\item{m_prec}{The precision of the mean, as number of digits after the decimal point.
If not provided, taken based on the significant digits of \code{mean} - so only needed if reported mean ends in 0}

\item{sd_prec}{The precision of the standard deviation, again only needed if
reported standard deviation ends in 0.}

\item{n_items}{Number of items in scale, if distribution represents scale averages.
Defaults to 1, which represents any single-item measure.}

\item{restrictions_exact}{Restrictions on the exact frequency of specific responses, see Details}

\item{restrictions_minimum}{Restrictions on the minimum frequency of specific responses, see Details}

\item{dont_test}{By default, this function tests whether the mean is possible, given the sample size (GRIM-test) and whether
the standard deviation is possible, given mean and sample size (GRIMMER test), and fails otherwise. If you want to override this,
and run SPRITE anyway, you can set this to TRUE.}
}
\value{
A named list of parameters, pre-processed for further rsprite2 functions.
}
\description{
The SPRITE algorithm aims to construct possible distributions that conform to
observed/reported parameters. This function performs some checks and returns a list of these
parameters that can then be passed to the functions that actually generate
the distributions (e.g. \code{\link{find_possible_distribution}})
}
\details{
Restrictions can be used to define how often a specific value should appear in the sample.
They need to be passed as a list in the form \code{value = frequency}. Thus, to specify that
there should be no 3s and five 4s in the distribution, you would pass
\code{restrictions_exact = list("3" = 0, "4" = 5)}. To specify that there should be at least
one 1 and one 7, you would pass \code{restrictions_minimum = list("1" = 1, "7" = 1)}. If you just want to
specify that the minimum and maximum values appear at least once (for instance when they are the
reported rather than possible range), you can use the shortcut \code{restrictions_minimum = "range"}. Finally,
if you work with multi-item scales that result in decimal responses, round those names to two decimal points, e.g.,
when \code{n_items = 3} you could specify \code{list("1.67" = 0)}.
}
\examples{

set.seed(1234) #To get reproducible results

# Simple case
sprite_parameters <- set_parameters(mean = 2.2, sd = 1.3, n_obs = 20, min_val = 1, max_val = 5)
find_possible_distribution(sprite_parameters)

# With restrictions
sprite_parameters <- set_parameters(mean = 1.95, sd = 1.55, n_obs = 20,
                                    min_val = 1, max_val = 5, n_items = 3,
                                    restrictions_exact = list("3"=0, "3.67" = 2),
                                    restrictions_minimum = "range")
find_possible_distribution(sprite_parameters)

}
