% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compact.R
\name{compact}
\alias{compact}
\alias{compact,character-method}
\alias{compact,SsimLibrary-method}
\title{Compacts a SsimLibrary}
\usage{
compact(ssimLibrary)

\S4method{compact}{character}(ssimLibrary)

\S4method{compact}{SsimLibrary}(ssimLibrary)
}
\arguments{
\item{ssimLibrary}{\code{\link{SsimLibrary-class}} object}
}
\value{
Invisibly returns \code{TRUE} upon success (i.e.successful
compacting) and \code{FALSE} upon failure.
}
\description{
Compact a \code{\link{SsimLibrary-class}}. Removes extraneous data from the SyncroSim library.
}
\examples{
\dontrun{
# Specify file path and name of new SsimLibrary
myLibraryName <- file.path(tempdir(), "testlib")

# Set up a SyncroSim Session, SsimLibrary, and Project
mySession <- session()
myLibrary <- ssimLibrary(name = myLibraryName, session = mySession)

# Compact data from the SsimLibrary
compact(myLibrary)
}

}
