% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gam.R
\name{predict_polar_gam}
\alias{predict_polar_gam}
\title{Get all predictions from a polar GAM model}
\usage{
predict_polar_gam(
  model,
  origin = NULL,
  exclude_terms = NULL,
  length_out = 50,
  values = NULL,
  return_ci = FALSE,
  ci_z = 1.96
)
}
\arguments{
\item{model}{A \link[rticulate]{polar_gam} model object.}

\item{origin}{The coordinates of the origin as a vector of \code{c(x, y)} coordinates.}

\item{exclude_terms}{Terms to be excluded from the prediction. Term names should be given as they appear in the model summary (for example, \code{"s(x0,x1)"}).}

\item{length_out}{An integer indicating how many values along the numeric predictors to use for predicting the outcome term (the default is \code{50}).}

\item{values}{User supplied values for numeric terms as a named list.}

\item{return_ci}{Whether to return a tibble with cartesian confidence intervals (for use with \link[rticulate]{geom_polar_ci}).}

\item{ci_z}{The z-value for calculating the CIs (the default is \code{1.96} for 95 percent CI).}
}
\value{
A tibble with predictions from a \link[rticulate]{polar_gam} model.
}
\description{
It returns a tibble with the predictions from all the terms in a \link[rticulate]{polar_gam} model.
}
\details{
The function converts the coordinates from polar to cartesian automatically.

To see an example of plotting, see the examples in \link[rticulate]{geom_polar_ci}.
}
\examples{
\donttest{
library(dplyr)
tongue_it01 <- filter(tongue, speaker == "it01")
it01_pol <- polar_gam(Y ~ s(X, by = c2_place) + s(X, word, bs = "fs"),
data = tongue_it01)

# get predictions
it01_pred <- predict_polar_gam(it01_pol)

# get predictions excluding the random smooth for word (the coefficient for
# the random smooth is set to 0)
it01_excl_rand <- predict_polar_gam(it01_pol, exclude_terms = "s(X,word)")
}
}
