% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadLCS.R
\name{loadLCS}
\alias{loadLCS}
\title{Load the living conditions survey (INE)}
\usage{
loadLCS(lcs_d_file, lcs_h_file)
}
\arguments{
\item{lcs_d_file, }{a string with the filename of \code{D}-file.}

\item{lcs_h_file, }{a string with the filename of \code{H}-file.}
}
\value{
A data frame containing the variables required.
}
\description{
\code{loadLCS()} loads the living conditions survey from Spanish National
Statistics Institute (\acronym{INE} in Spanish).
}
\details{
Regularly the INE releases the living conditions survey through two different
files which can be downloaded for free. The filename of these files contains
the letters \code{D} and \code{H}, and these files include dozens of variables. Only some of these
variables are needed to do the calculations with \code{rtip} package.
}
\note{
We have included two files in dat-raw to test the function
(source version package only).
}
\examples{
\dontrun{lcs2014 <- loadLCS("esudb14d.csv","esudb14h.csv")}
}
\author{
A. Berihuete, C.D. Ramos and M.A. Sordo
}
