% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtmsBrukerMCFReader.R
\name{getSampleSet.rtmsBrukerMCFReader}
\alias{getSampleSet.rtmsBrukerMCFReader}
\alias{getBrukerMCFSampleSet}
\title{Extract a sample set from a Bruker MCF directory}
\usage{
\method{getSampleSet}{rtmsBrukerMCFReader}(x, peaks, ...)

getBrukerMCFSampleSet(reader, peaks, indices)
}
\arguments{
\item{x}{The MCF reader object}

\item{peaks}{A list of peak objects of class \code{rtmsPeak}}

\item{...}{Additional parameters}

\item{reader}{An RTMS reader object of class \code{rtmsBrukerMCFReader}}

\item{indices}{A vector of numeric indices specifying which acquisitions
the sample set should be extracted from}
}
\value{
An RTMS sample set object of class \code{rtmsSampleSet}
}
\description{
Extracts an RTMS sample object (of class \code{rtmsSampleSet}) from a multi-
acquisition Bruker MCF directory opened using an RTMS reader object (of
class \code{rtmsBrukerMCFReader}). A vector  numeric indices is used to identify
which acquisitions the sample set should be extracted from.
}
\section{Functions}{
\itemize{
\item \code{getSampleSet(rtmsBrukerMCFReader)}: The S3 method \code{getSample} for objects
of class \code{rtmsBrukerMCFReader}; calls \code{getBrukerMCFSampleSet}

}}
