% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/midas_functions.R
\name{DAGM_X_loglik}
\alias{DAGM_X_loglik}
\title{DAGM-X log-likelihood (with skewness)}
\usage{
DAGM_X_loglik(param, daily_ret, X, mv_m, K, distribution, lag_fun = "Beta")
}
\arguments{
\item{param}{Vector of starting values.}

\item{daily_ret}{Daily returns, which must be an "xts" object.}

\item{X}{Additional "X" variable, which must be an "xts" object. Morever, "X" must be observed for the same days of daily_ret.}

\item{mv_m}{MIDAS variable already transformed into a matrix, through \code{\link{mv_into_mat}} function.}

\item{K}{Number of (lagged) realizations of the MIDAS variable to consider.}

\item{distribution}{The conditional density to use for the innovations. At the moment, valid choices are "norm" and "std", for the Normal
and Student-t distributions.}

\item{lag_fun}{\strong{optional}. Lag function to use. Valid choices are "Beta" (by default) and "Almon",
for the Beta and Exponential Almon lag functions, respectively.}
}
\value{
The resulting vector is the log-likelihood value for each \eqn{i,t}.
}
\description{
Obtains the log-likelihood of the DAGM-X, with an asymmetric term linked to past negative returns,
according to two errors' conditional distributions: Normal and Student-t.
For details, see \insertCite{amendola_candila_gallo:2019;textual}{rumidas}.
}
\examples{
\donttest{
# conditional density of the innovations: normal
start_val<-c(0.01,0.80,0.05,0.05,0,0,1.1,0,1.1)
r_t<-sp500['2005/2010']
X<-rv5['2005/2010']^0.5
mv_m<-mv_into_mat(r_t,diff(indpro),K=12,"monthly")
sum(DAGM_X_loglik(start_val,r_t,X,mv_m,K=12,distribution="norm"))
}
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{mv_into_mat}}.
}
\keyword{internal}
