% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_description_repo.R
\name{get_description_repo}
\alias{get_description_repo}
\title{Get \emph{DESCRIPTION} files for R repos}
\usage{
get_description_repo(
  refs = NULL,
  db = NULL,
  repo = c("BioCsoft", "BioCann", "BioCexp", "BioCworkflows", "CRAN"),
  version = BiocManager::version(),
  verbose = TRUE
)
}
\arguments{
\item{refs}{Reference for one or more GitHub repository in owner/repo format
 (e.g.\code{"neurogenomics/rworkflows"}), or an R package name 
(e.g. \code{"rworkflows"}).}

\item{db}{A \link[data.table]{data.table} of R package metadata generated by
\link[BiocPkgTools]{biocPkgList}.}

\item{repo}{\code{character(1)} The requested Bioconductor repository. The default
is to pull from the "BioCsoft" repository. Possible repositories include
"BioCsoft", "BioCexp", "BioCworkflows", "BioCann", and "CRAN". Note that
not all repos are available for all versions, particularly older versions.}

\item{version}{The requested Bioconductor version. Will
default to use the BiocManager defaults (i.e., \code{version()}).}

\item{verbose}{Print messages.}
}
\value{
Named list of \link[desc]{desc} objects.
}
\description{
Get the \emph{DESCRIPTION} file information in
 \link[data.table]{data.table} format for all R packages 
in standard R repositories (CRAN, Bioc).
 Can return a subset of results for specific packages as well.
}
\keyword{internal}
