% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeplot.acsf.cumulative.R
\name{makeplot.acsf.cumulative}
\alias{makeplot.acsf.cumulative}
\title{Plot the Change in Split Frequencies (CSF) in sliding windows over the course of an MCMC.}
\usage{
makeplot.acsf.cumulative(chains, burnin = 0, window.size = 20, facet = TRUE)
}
\arguments{
\item{chains}{A list of rwty.chain objects.}

\item{burnin}{The number of trees to eliminate as burnin. Defaults to zero.}

\item{window.size}{The number of trees to include in each window (note, specified as a number of sampled trees, not a number of generations)}

\item{facet}{(TRUE/FALSE). TRUE: return a single plot with one facet per chain; FALSE: return a list of individual plots with one plot per chain}
}
\value{
output A plof of the CSF between sliding windows over all chains

acsf.plot A ggplot object, or list of ggplot objects
}
\description{
This function takes one or more rwty.chain ojects and returns a plot of CSF within each chain as the MCMC progresses.  
The solid line with points shows the Average Change in Split Frequencies (ACSF; it is average across the changes in split frequencies from all clades in the analysis) between this window and the previous window
The grey ribbon shows the upper and lower 95% quantiles of the CSFs between this window and the previuos window
}
\examples{
\dontrun{
data(fungus)
makeplot.acsf.cumulative(fungus, burnin=20)
}
}
\keyword{convergence}
\keyword{mcmc}
\keyword{phylogenetics}
\keyword{uncertainty}
