% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asIni.R
\name{as.ini}
\alias{as.ini}
\alias{as.ini.character}
\alias{as.ini.data.frame}
\alias{as.ini.call}
\alias{as.ini.lotriFix}
\alias{as.ini.matrix}
\alias{as.ini.default}
\title{Turn into an ini block for initialization}
\usage{
as.ini(x)

\method{as.ini}{character}(x)

\method{as.ini}{data.frame}(x)

\method{as.ini}{call}(x)

\method{as.ini}{lotriFix}(x)

\method{as.ini}{matrix}(x)

\method{as.ini}{default}(x)
}
\arguments{
\item{x}{Item to convert to a rxode2/nlmixr2 ui ini expression}
}
\value{
rxode2 ini expression
}
\description{
Turn into an ini block for initialization
}
\examples{

ini <- quote(ini({
  tka <- log(1.57)
  tcl <- log(2.72)
  tv <- log(31.5)
  eta.ka ~ 0.6
  eta.cl ~ 0.3
  eta.v ~ 0.1
  add.sd <- 0.7
}))

as.ini(ini)

l <- quote(lotri({
  tka <- log(1.57)
  tcl <- log(2.72)
  tv <- log(31.5)
  eta.ka ~ 0.6
  eta.cl ~ 0.3
  eta.v ~ 0.1
  add.sd <- 0.7
 }))

as.ini(l)

m <- lotri({
   eta.ka ~ 0.6
   eta.cl ~ 0.3
   eta.v ~ 0.1
})

as.ini(m)

one.compartment <- function() {
  ini({
    tka <- log(1.57)
    tcl <- log(2.72)
    tv <- log(31.5)
    eta.ka ~ 0.6
    eta.cl ~ 0.3
    eta.v ~ 0.1
    add.sd <- 0.7
  })
  model({
    ka <- exp(tka + eta.ka)
    cl <- exp(tcl + eta.cl)
    v <- exp(tv + eta.v)
    d/dt(depot) = -ka * depot
    d/dt(center) = ka * depot - cl / v * center
    cp = center / v
    cp ~ add(add.sd)
  })
}

as.ini(one.compartment)

ui <- one.compartment()

as.ini(ui)

ui$iniDf

as.ini(ui$iniDf)

ini <- c("ini({",
          "tka <- log(1.57)",
          "tcl <- log(2.72)",
          "tv <- log(31.5)",
          "eta.ka ~ 0.6",
          "eta.cl ~ 0.3",
          "eta.v ~ 0.1",
          "add.sd <- 0.7",
          "})")

as.ini(ini)

ini <- paste(ini, collapse="\n")

as.ini(ini)

}
\author{
Matthew L. Fidler
}
