% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s20x-data.R
\docType{data}
\name{apples.df}
\alias{apples.df}
\title{Apples Data}
\format{
The data consist of a data frame with 104 observations on 4 variables.
\describe{
\item{Rootstock}{factor. levels (I, II, III, IV, IX, V, VI, VII, X, XII, XIII, XV, XVI)}
\item{Weight}{integer. Above-ground weight of tree (pounds, lb).}
\item{Weight_kg}{numeric. Above-ground weight of tree (kilograms, kg); \code{Weight_kg = Weight * 0.45359237}.}
\item{Propagated}{factor. levels (cutting, seed)}
}
}
\description{
These data come from a classic long-term experiment conducted at the East
Malling Research Station, Kent, which is the centre four research into apple
growing in the U.K. Commercial apple trees consist of two parts grafted
together. The lowest part, the \emph{rootstock}, largely determines the size
of the tree, while the upper part (the \emph{scion}) determines the fruit
characteristics. Rootstocks propagated by cuttings (i.e. asexually produced)
were once thought to result in smaller trees than those propagated from
seeds (i.e. sexually produced). This hypothesis was re-examined in an
experiment begun in 1918. Several trees of each type of 16 types of
rootstock were planted, all trees having the same scion. Rootstocks I-IX
were asexually produced, while X-XVI were sexually produced. In the winter
of 1933-4 a number of trees were removed to make room for more, and the data
presented here consists of the above ground weights of 104 trees felled in
this period. No trees of types VIII, XI or XIV were felled.  The description
is from Lee (\cite{Lee, A.J. Data analysis. An introduction based on R.
University of Auckland 1994}). The data are from Andrews and Herzberg
(1985).
}
\keyword{datasets}
