% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot2VarsVsLTime.R
\name{Plot2VarsVsLTime}
\alias{Plot2VarsVsLTime}
\title{Plot two scores with confidence intervals in a common plot}
\usage{
Plot2VarsVsLTime(
  var1,
  var2,
  toptitle = "",
  ytitle = "",
  monini = 1,
  freq = 12,
  nticks = NULL,
  limits = NULL,
  listexp = c("exp1", "exp2", "exp3"),
  listvars = c("var1", "var2"),
  biglab = FALSE,
  hlines = NULL,
  leg = TRUE,
  siglev = FALSE,
  sizetit = 1,
  show_conf = TRUE,
  fileout = NULL,
  width = 8,
  height = 5,
  size_units = "in",
  res = 100,
  ...
)
}
\arguments{
\item{var1}{Matrix of dimensions (nexp/nmod, nltime).}

\item{var2}{Matrix of dimensions (nexp/nmod, nltime).}

\item{toptitle}{Main title, optional.}

\item{ytitle}{Title of Y-axis, optional.}

\item{monini}{Starting month between 1 and 12. Default = 1.}

\item{freq}{1 = yearly, 12 = monthly, 4 = seasonal, ... Default = 12.}

\item{nticks}{Number of ticks and labels on the x-axis, optional.}

\item{limits}{c(lower limit, upper limit): limits of the Y-axis, optional.}

\item{listexp}{List of experiment names, up to three, optional.}

\item{listvars}{List of names of input variables, optional.}

\item{biglab}{TRUE/FALSE for presentation/paper plot. Default = FALSE.}

\item{hlines}{c(a, b, ...) Add horizontal black lines at Y-positions a, b, 
... The default value is NULL.}

\item{leg}{TRUE/FALSE if legend should be added or not to the plot. 
Default = TRUE.}

\item{siglev}{TRUE/FALSE if significance level should replace confidence 
interval.\cr 
Default = FALSE.}

\item{sizetit}{Multiplicative factor to change title size, optional.}

\item{show_conf}{TRUE/FALSE to show/not confidence intervals for input 
variables.}

\item{fileout}{Name of output file. Extensions allowed: eps/ps, jpeg, png, 
pdf, bmp and tiff. The default value is NULL.}

\item{width}{File width, in the units specified in the parameter size_units 
(inches by default). Takes 8 by default.}

\item{height}{File height, in the units specified in the parameter 
size_units (inches by default). Takes 5 by default.}

\item{size_units}{Units of the size of the device (file or window) to plot 
in. Inches ('in') by default. See ?Devices and the creator function of the 
corresponding device.}

\item{res}{Resolution of the device (file or window) to plot in. See 
?Devices and the creator function of the corresponding device.}

\item{...}{Arguments to be passed to the method. Only accepts the following
graphical parameters:\cr  
adj ann ask bg bty cex.sub cin col.axis col.lab col.main col.sub cra crt 
csi cxy err family fg fig font font.axis font.lab font.main font.sub lend 
lheight ljoin lmitre mar mex mfcol mfrow mfg mkh oma omd omi page pch plt 
smo srt tck tcl usr xaxp xaxs xaxt xlog xpd yaxp yaxs yaxt ylbias ylog \cr
For more information about the parameters see `par`.}
}
\value{
No return value, called for side effects.
}
\description{
Plot two input variables that have the same dimensions in a common plot.
One plot for all experiments.
The input variables should have dimensions (nexp/nmod, nltime).
}
\details{
Examples of input:\cr
------------------\cr\cr  
RMSE error for a number of experiments and along lead-time: (nexp, nltime)
}
\examples{
# Load sample data as in Load() example:
example(LoadSampleData)
clim <- Clim(sampleData$mod, sampleData$obs)
ano_exp <- Ano(sampleData$mod, clim$clim_exp)
ano_obs <- Ano(sampleData$obs, clim$clim_obs)
runmean_months <- 12
smooth_ano_exp <- Smoothing(data = ano_exp, runmeanlen = runmean_months)
smooth_ano_obs <- Smoothing(data = ano_obs, runmeanlen = runmean_months)
dim_to_mean <- 'member'  # mean along members
required_complete_row <- 'ftime'  # discard startdates for which there are NA leadtimes
leadtimes_per_startdate <- 60
rms <- RMS(MeanDims(smooth_ano_exp, dim_to_mean), 
           MeanDims(smooth_ano_obs, dim_to_mean), 
           comp_dim = required_complete_row, dat_dim = 'dataset',
           limits = c(ceiling((runmean_months + 1) / 2), 
           leadtimes_per_startdate - floor(runmean_months / 2)))
smooth_ano_exp_m_sub <- smooth_ano_exp - InsertDim(MeanDims(smooth_ano_exp, 'member', 
                                                            na.rm = TRUE), 
                                                   posdim = 3, 
                                                   lendim = dim(smooth_ano_exp)['member'], 
                                                   name = 'member')
suppressWarnings({
spread <- Spread(smooth_ano_exp_m_sub, compute_dim = c('member', 'sdate'))
})
#Combine rms outputs into one array 
rms_combine <- abind::abind(rms$conf.lower, rms$rms, rms$conf.upper, along = 0)
rms_combine <- Reorder(rms_combine, c(2, 3, 1, 4))
\donttest{
Plot2VarsVsLTime(InsertDim(rms_combine[, , , ], 1, 1), Reorder(spread$sd, c(1, 3, 2)), 
                 toptitle = 'RMSE and spread', monini = 11, freq = 12, 
                 listexp = c('CMIP5 IC3'), listvar = c('RMSE', 'spread'))
}

}
