% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clim.palette.R
\name{clim.palette}
\alias{clim.palette}
\alias{clim.colors}
\title{Generate Climate Color Palettes}
\usage{
clim.palette(palette = "bluered")

clim.colors(n, palette = "bluered")
}
\arguments{
\item{palette}{Which type of palette to generate: from blue through white 
to red ('bluered'), from red through white to blue ('redblue'), from 
yellow through orange to red ('yellowred'),  from red through orange to
red ('redyellow'), from purple through white to orange ('purpleorange'),
and from orange through white to purple ('orangepurple').}

\item{n}{Number of colors to generate.}
}
\value{
A function that generates a vector of \code{n} color hex codes when 
called. The returned function has an optional attribute \code{"na_color"} 
specifying the color used for missing values.
}
\description{
Generates a colorblind friendly color palette with color ranges useful in 
climate temperature variable plotting.
}
\examples{
lims <- seq(-1, 1, length.out = 21)

ColorBar(lims, color_fun = clim.palette('redyellow'))

cols <- clim.colors(20)
ColorBar(lims, cols)

}
