% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_get_files.R
\name{s3_get_files}
\alias{s3_get_files}
\title{download several s3 files}
\usage{
s3_get_files(
  s3_uri,
  region = "us-east-2",
  progress = FALSE,
  force = FALSE,
  confirm = TRUE,
  public = FALSE,
  data_dir = tools::R_user_dir("s3", "data")
)
}
\arguments{
\item{s3_uri}{vector of S3 object URIs}

\item{region}{AWS region for bucket containing the file (defaults to "us-east-2", but only required for private files)}

\item{progress}{show download progress for each individual file? (currently only for public objects)}

\item{force}{force download to overwrite existing S3 objects}

\item{confirm}{ask user to interactively confirm downloads? (only possible when session is interactive)}

\item{public}{defaults to FALSE; if TRUE, ignore any environment
variables specifying AWS credentials and
attempt to download the file as publicly available}

\item{data_dir}{root directory for downloaded files (defaults to \code{tools::R_user_dir("s3", "data")})}
}
\value{
data.frame (or tibble) with s3_uris and corresponding file paths to downloaded files (invisibly)
}
\description{
Progress messages for downloading several S3 objects at once cannot be silenced.
Like s3_get, S3 objects that have already been downloaded will not be re downloaded
}
\examples{
\donttest{
Sys.setenv("R_USER_DATA_DIR" = tempdir())
the_files <- s3_get_files(c(
    "s3://geomarker/testing_downloads/mtcars.rds",
    "s3://geomarker/testing_downloads/mtcars.fst"
))
unlink(the_files$file_path)
}
}
