% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sSDR.R
\name{gOLS.comp.d}
\alias{gOLS.comp.d}
\title{Groupwise OLS (gOLS) BIC criterion to estimate dimensions with
eigen-decomposition}
\usage{
gOLS.comp.d(X, y, groups)
}
\arguments{
\item{X}{A covariate matrix of n observations and p predictors.}

\item{y}{A univariate response.}

\item{groups}{A vector with the number of predictors in each group.}
}
\value{
gOLS.comp.d returns a list containning at least the following
components:
"d", the estimated dimension (at most 1) for each predictor group;
"crit", the BIC criterion from each iteration.
}
\description{
Groupwise OLS (gOLS) BIC criterion to estimate dimensions with
eigen-decomposition
}
\details{
This function estimates dimension for each predictor group using
eigen-decomposition. Predictors need to be organized in groups within the
"X" matrix, as the same order saved in "groups". We only allow continuous
covariates in the "X" matrix; while categorical covariates can be handled
outside of gOLS, e.g. structured OLS.
}
\examples{
data <- gen.data(n=1000, binary=FALSE) # generate data
dim(data$X) # covariate matrix of 1000 observations and 15 predictors
dim(data$y) # univariate response
groups <- c(5, 10) # two predictor groups and their numbers of predictors
dim_gOLS<-gOLS.comp.d(data$X,data$y,groups)
names(dim_gOLS)
}
\references{
Liu, Y., Chiaromonte, F., and Li, B. (2015). Structured Ordinary
Least Squares: a sufficient dimension reduction approach for regressions with
 partitioned predictors and heterogeneous units. Submitted.
}

