% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_df_mod.R
\name{sim_df_mod}
\alias{sim_df_mod}
\title{Simulate an Individual (Augmented) Dickey-Fuller Model}
\usage{
sim_df_mod(x, ts_type, df_lags = NULL, classic_df = FALSE, wn = FALSE)
}
\arguments{
\item{x}{a numeric vector corresponding to a series to replicate/simulate}

\item{ts_type}{a type of time-series to simulate (either 'ndnt', 'dnt', or 'dt')}

\item{df_lags}{a numeric vector for the number of lags to calculate for the test.}

\item{classic_df}{logical, defaults to FALSE. If FALSE, the function calculates
an "Augmented" Dickey-Fuller test on a simulated series with the number of lagged
first differences requested in the \code{df_lags} argument. If \code{TRUE}, the classic
Dickey-Fuller test is executed without the lagged first differences.}

\item{wn}{logical, defaults to FALSE. If FALSE, generates a random
walk of some description for a DF/ADF test. If TRUE, series to be simulated
for a DF/ADF test is white noise.}
}
\value{
\code{sim_df_mod()} returns the output of a linear model (with class
\code{lm}) that performs a(n Augmented) Dickey-Fuller test on a simulated time
series. This is mostly for internal use, but it might pique the user's
interest to see such a test in action independent of simulated summaries
generated by \code{sadf_test()}.
}
\description{
\code{sim_df_mod()} is designed as a helper function, to be used
internally in this package in \code{sadf_test()}. But, you can use it here to
simulate a time series and perform a(n Augmented) Dickey-Fuller test.
}
\details{
\code{classic_df = TRUE} suppresses the need to specify \code{df_lags = 0}, but
\code{df_lags} cannot be 0 if \code{classic_df = FALSE}.

This might change in future iterations, but it's worth clarifying the values
assigned to the parameters of a drift and trend. The drift is randomly
generated from a Rademacher distribution for both the times series with drift
and drift-and-trend. The series with a deterministic trend divides the value
from the Rademacher distribution by 10. My rationale is largely based on what
I've seen other pedagogical guides do, the extent to which they talk about
simulating values for these types of random walks.
}
\examples{

set.seed(8675309) # don't want new numbers in documentation every time...

sim_df_mod(rnorm(25), ts_type = 'ndnt', classic_df = TRUE)

sim_df_mod(rnorm(25), ts_type = 'ndnt', df_lags = 2, classic_df = FALSE)

}
\author{
Steven V. Miller
}
