% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ziBinomial.R
\name{ziBinomial}
\alias{ziBinomial}
\title{Small Area Estimation using Hierarchical Bayesian under Zero Inflated Binomial Distribution}
\usage{
ziBinomial(
  formula,
  n.samp,
  iter.update = 3,
  iter.mcmc = 10000,
  coef.nonzero,
  var.coef.nonzero,
  coef.zero,
  var.coef.zero,
  thin = 2,
  burn.in = 2000,
  tau.u.nZ = 1,
  data
)
}
\arguments{
\item{formula}{Formula that describe the fitted model}

\item{n.samp}{Number of sample in each area}

\item{iter.update}{Number of updates with default \code{3}}

\item{iter.mcmc}{Number of total iterations per chain with default \code{2000}}

\item{coef.nonzero}{Optional argument for mean on coefficient's prior distribution or \eqn{\beta}'s prior distribution which value is non-zero}

\item{var.coef.nonzero}{Optional argument for the variances of the prior distribution of the model coefficients (\eqn{\beta})}

\item{coef.zero}{Optional argument for mean on coefficient's prior distribution or \eqn{\alpha}'s prior distribution which value is non-zero}

\item{var.coef.zero}{Optional argument for the variances of the prior distribution of the model coefficients (\eqn{\alpha})}

\item{thin}{Thinning rate, must be a positive integer with default \code{1}}

\item{burn.in}{Number of iterations to discard at the beginning with default \code{1000}}

\item{tau.u.nZ}{Variance of random effect area for non-zero of variable interest \eqn{(y)} with default \code{1}}

\item{data}{The data frame}
}
\value{
This function returns a list of the following objects:
 \item{Est}{A vector with the values of Small Area mean Estimates using Hierarchical bayesian method}
 \item{refVar}{Estimated random effect variances}
 \item{coefficient}{A dataframe with the estimated model coefficient}
 \item{plot_alpha}{Trace, Density, Autocorrelation Function Plot of MCMC samples}
 \item{plot_beta}{Trace, Density, Autocorrelation Function Plot of MCMC samples}
}
\description{
This function is implemented to variable of interest \eqn{(y)} that assumed to be a Zero Inflated Binomial Distribution. The range of data is \eqn{(0 < y < \infty)}. This model can be used to handle overdispersion caused by excess zero in data.
}
\examples{
#Compute Fitted Model
 y ~ X1 +X2

# For data without any nonsampled area
# Load Dataset
  data(dataZIB)
  saeHB.ZIB <- ziBinomial(formula = y~X1+X2, "s", iter.update=3, iter.mcmc = 1000,
                burn.in = 200,data = dataZIB)
#the setting of iter.update, iter.mcmc, and burn.in in this example
#is considered to make the example execution time be faster.
#Result
saeHB.ZIB$Est                                    #Small Area mean Estimates
saeHB.ZIB$Est$SD                                 #Standard deviation of Small Area Mean Estimates
saeHB.ZIB$refVar                                 #refVar
saeHB.ZIB$coefficient                            #coefficient
#Load Library 'coda' to execute the plot
#autocorr.plot(saeHB.ZIB$plot_alpha[[3]]) is used to   #ACF Plot for alpha
#autocorr.plot(saeHB.ZIB$plot_beta[[3]]) is used to    #ACF Plot for beta
#plot(saeHB.ZIB$plot_alpha[[3]]) is used to            #Dencity and trace plot for alpha
#plot(saeHB.ZIB$plot_beta[[3]]) is used to             #Dencity and trace plot for beta
}
