% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Panel.R
\name{Panel}
\alias{Panel}
\title{Small Area Estimation using Hierarchical Bayesian under Rao-Yu Model with \code{rho=0}}
\usage{
Panel(
  formula,
  area,
  period,
  vardir,
  iter.update = 3,
  iter.mcmc = 2000,
  thin = 2,
  burn.in = 1000,
  tau.e = 1,
  tau.v = 1,
  data
)
}
\arguments{
\item{formula}{Formula that describe the fitted model}

\item{area}{Number of areas (domain) of the data}

\item{period}{Number of periods (subdomains) for each area of the data}

\item{vardir}{Sampling variances of direct estimations}

\item{iter.update}{Number of updates with default \code{3}}

\item{iter.mcmc}{Number of total iterations per chain with default \code{2000}}

\item{thin}{Thinning rate, must be a positive integer with default \code{1}}

\item{burn.in}{Number of iterations to discard at the beginning with default \code{1000}}

\item{tau.e}{Variance of area-by-time effect of variable interest with default \code{1}}

\item{tau.v}{Variance of random area effect of variable interest with default \code{1}}

\item{data}{The data frame}
}
\value{
This function returns a list of the following objects:
   \item{Est}{A vector with the values of Small Area mean Estimates using Hierarchical bayesian method}
   \item{refVar}{Estimated random effect variances}
   \item{coef}{A dataframe with the estimated model coefficient}
   \item{plot}{Trace, Density, Autocorrelation Function Plot of MCMC samples}
}
\description{
This function is implemented to variable of interest \code{ydi}
}
\examples{
##For data without any non-sampled area
data(dataPanel)     # Load dataset
formula = ydi ~ xdi1 + xdi2
area = max(dataPanel[, "area"])
period = max(dataPanel[,"period"])
vardir = dataPanel[,"vardir"]

result <- Panel(formula, area, period, vardir, data = dataPanel)

result$Est
result$refVar
result$coef
result$plot


## For data with non-sampled area use dataPanelNs

}
