% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-sim_gen_cont.R
\name{sim_gen_cont}
\alias{sim_gen_cont}
\title{Generation Component for contamination}
\usage{
sim_gen_cont(simSetup, generator, nCont, type, areaVar = NULL, fixed = TRUE)
}
\arguments{
\item{simSetup}{a \code{sim_setup}.}

\item{generator}{generator function used to generate random numbers.}

\item{nCont}{gives the number of contaminated observations. Values between 0 
and 1 will be treated as probability. If type is 'unit' and length is
larger than 1, the expected length is the number of areas. If type is
'area' and length is larger than 1 the values are interpreted as area
positions; i.e. \code{c(1, 3)} is interpreted as the first and 3rd area in
the data is contaminated.}

\item{type}{"unit" or "area" - unit- or area-level contamination.}

\item{areaVar}{character with variable name(s) identifying areas.}

\item{fixed}{TRUE fixes the observations which will be contaminated. FALSE
will result in a random selection of observations or areas.}
}
\description{
One of the components which can be added to a \code{sim_setup}. It is applied after functions added with \code{\link{sim_gen}}.
}
\examples{
sim_base_lm() \%>\% 
  sim_gen_cont(gen_norm(name = "e"), nCont = 0.05, type = "unit", areaVar = "idD") \%>\%
  as.data.frame
}
\seealso{
\code{\link{sim_gen}}
}
