% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type.R
\name{type}
\alias{type}
\title{Type Selection Helper}
\usage{
type(x)
}
\arguments{
\item{x}{Character indicating the desired type. Options include \code{date},
\code{category}, \code{numeric}, \code{binary} at this time.}
}
\value{
A vector of classes
}
\description{
Function to swiftly provide access to generic categories of types within R.
These can be used to provide comprehensive typesetting when creating a
\code{safeframe} object.
}
\examples{
x <- make_safeframe(cars,
  mph = "speed",
  distance = "dist"
)

validate_types(
  x,
  mph = type("numeric"),
  distance = "numeric"
)

}
