% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sakura.R
\name{serialize}
\alias{serialize}
\alias{unserialize}
\title{Serialize}
\usage{
serialize(x, hook = NULL)

unserialize(x, hook = NULL)
}
\arguments{
\item{x}{an object.}

\item{hook}{[default NULL] optionally, a configuration returned by
\code{\link{serial_config}}.}
}
\value{
For serialize: a raw vector. For unserialize: the unserialized object.
}
\description{
An extension of R native serialization using the 'refhook' system for custom
serialization and unserialization of non-system reference objects.
}
\examples{
vec <- serialize(data.frame())
vec
unserialize(vec)

\dontshow{if (requireNamespace("arrow", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
obj <- list(arrow::as_arrow_table(iris), arrow::as_arrow_table(mtcars))
cfg <- serial_config(
  "ArrowTabular",
  arrow::write_to_raw,
  function(x) arrow::read_ipc_stream(x, as_data_frame = FALSE)
)
raw <- serialize(obj, cfg)
unserialize(raw, cfg)
\dontshow{\}) # examplesIf}
}
