% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define-SOM.R
\docType{class}
\name{SOM-class}
\alias{SOM-class}
\alias{SOM}
\title{Class \code{"SOM"}}
\description{
An object containing all the parameters for a salmon operating model (SOM).
}
\section{Slots}{

\describe{
\item{\code{Name}}{Character. Identifying name}

\item{\code{nsim}}{Integer. Number of simulations}

\item{\code{nyears}}{Integer. The number of historical years}

\item{\code{proyears}}{Integer. The number of projected years}

\item{\code{seed}}{Integer. A random seed to ensure users can reproduce results exactly}

\item{\code{Bio}}{\linkS4class{Bio} object informing biological parameters, natural production, and habitat effects. Provide a list of Bio objects for multi-population models.}

\item{\code{Habitat}}{\linkS4class{Habitat} object containing management levers for habitat mitigation. Provide a list of Habitat objects for multi-population models.}

\item{\code{Hatchery}}{\linkS4class{Hatchery} object containing management levers for hatchery production. Provide a list of Hatchery objects for multi-population models.}

\item{\code{Harvest}}{\linkS4class{Harvest} object containing management levers for harvest. Provide a list of Harvest objects for multi-population models.}

\item{\code{Historical}}{\linkS4class{Historical} object to inform historical reconstruction and informing starting abundance for the projection. Provide a list of Historical objects for multi-population models.}

\item{\code{stray}}{Matrix \verb{[np, np]} where \code{np = length(Bio)} and row \code{p} indicates the re-assignment of hatchery fish to each population when they mature (at the recruitment life stage). For example,
\code{SOM@stray <- matrix(c(0.75, 0.25, 0.25, 0.75), 2, 2)} indicates that 75 percent of mature fish return to their natal river and 25 percent stray in both populations. By default, an identity matrix is used (no straying).}
}}

\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new("SOM", Bio, Habitat, Hatchery, Harvest, Historical)}.
}

\keyword{classes}
