% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-LHG.R
\name{plot_LHG}
\alias{plot_LHG}
\alias{plot_RS}
\title{Plot life history groups and release strategies}
\usage{
plot_LHG(
  SMSE,
  var = "NOS",
  type = c("prop", "abs"),
  s = 1,
  FUN = median,
  figure = TRUE,
  xlab = "Projection Year",
  ylab,
  name,
  ylim
)

plot_RS(
  SMSE,
  var = "HOS",
  type = c("prop", "abs"),
  s = 1,
  FUN = median,
  figure = TRUE,
  xlab = "Projection Year",
  ylab,
  name,
  ylim
)
}
\arguments{
\item{SMSE}{Class \linkS4class{SMSE} object returned by \code{\link[=salmonMSE]{salmonMSE()}}}

\item{var}{Character. Slot for the state variables in \code{SMSE@Misc$LHG[[1]]} or \code{SMSE@Misc$RS[[1]]}.}

\item{type}{Character to indicate whether to plot proportion or absolute numbers}

\item{s}{Integer. Population index for multi-population model (e.g., \code{s = 1} is the first population in the model)}

\item{FUN}{Summarizing function across simulations, typically \code{\link[=median]{median()}} or \code{\link[=mean]{mean()}}}

\item{figure}{Logical, whether to generate a figure (set to FALSE if only using the function to return the data matrix)}

\item{xlab}{Character. Name of time variable for the figure}

\item{ylab}{Character. Name of the state variable for the figure}

\item{name}{Character. Vector of names for the life history groups or release strategies}

\item{ylim}{Vector length 2, y-axis limits}
}
\value{
Base graphics figure, barplot of distribution or total numbers by LHG or RS. Returns invisibly the matrix of plotted values
}
\description{
Plot the annual proportions of life history groups (natural origin fish) or release strategies (hatchery origin) at various life stages
}
\seealso{
\code{\link[=plot_statevar_ts]{plot_statevar_ts()}}
}
