% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roxido.R
\docType{package}
\name{salso-package}
\alias{salso-package}
\title{salso: Search Algorithms and Loss Functions for Bayesian Clustering}
\description{
The SALSO algorithm is an efficient randomized greedy search method to find a point estimate for a random partition based on a loss function and posterior Monte Carlo samples. The algorithm is implemented for many loss functions, including the Binder loss and a generalization of the variation of information loss, both of which allow for unequal weights on the two types of clustering mistakes. Efficient implementations are also provided for Monte Carlo estimation of the posterior expected loss of a given clustering estimate. See Dahl, Johnson, Müller (2022) \doi{10.1080/10618600.2022.2069779}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/dbdahl/salso}
  \item Report bugs at \url{https://github.com/dbdahl/salso/issues}
}

}
\author{
\strong{Maintainer}: David B. Dahl \email{dahl@stat.byu.edu} (\href{https://orcid.org/0000-0002-8173-1547}{ORCID})

Authors:
\itemize{
  \item Devin J. Johnson \email{devin.j.johnson7@gmail.com} (\href{https://orcid.org/0000-0003-2619-6649}{ORCID})
  \item Peter Müller \email{pmueller@math.utexas.edu}
  \item Andrés Felipe Barrientos \email{abarrientos@fsu.edu}
  \item Garritt Page \email{page@stat.byu.edu}
  \item David Dunson \email{dunson@duke.edu}
}

Other contributors:
\itemize{
  \item Alex Crichton \email{alex@alexcrichton.com} (Rust crates: cfg-if, proc-macro2) [contributor]
  \item Brendan Zabarauskas \email{bjzaba@yahoo.com.au} (Rust crate: approx) [contributor]
  \item David B. Dahl \email{dahl@stat.byu.edu} (Rust crates: dahl-bellnumber, dahl-partition, dahl-salso, roxido, roxido_macro) [contributor]
  \item David Tolnay \email{dtolnay@gmail.com} (Rust crates: proc-macro2, quote, syn, unicode-ident) [contributor]
  \item Jim Turner (Rust crate: ndarray) [contributor]
  \item Josh Stone \email{cuviper@gmail.com} (Rust crate: autocfg) [contributor]
  \item R. Janis Goldschmidt (Rust crate: matrixmultiply) [contributor]
  \item Sean McArthur \email{sean@seanmonstar.com} (Rust crate: num_cpus) [contributor]
  \item Stefan Lankes (Rust crate: hermit-abi) [contributor]
  \item The Cranelift Project Developers (Rust crate: wasi) [contributor]
  \item The CryptoCorrosion Contributors (Rust crates: ppv-lite86, rand_chacha) [contributor]
  \item The Rand Project Developers (Rust crates: getrandom, rand, rand_chacha, rand_core, rand_pcg) [contributor]
  \item The Rust Project Developers (Rust crates: libc, num-bigint, num-complex, num-integer, num-traits, rand, rand_chacha, rand_core) [contributor]
  \item Ulrik Sverdrup "bluss" (Rust crate: ndarray) [contributor]
  \item bluss (Rust crates: matrixmultiply, rawpointer) [contributor]
}

}
\keyword{internal}
