% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessdb.R
\name{sm_pivot_wider}
\alias{sm_pivot_wider}
\title{Reshape Long API Data to Column-Based Format}
\usage{
sm_pivot_wider(
  data,
  id_cols = intersect(.SAMADB_T, names(data)),
  names_from = "series",
  values_from = "value",
  labels_from = if (any(names(data) == "label")) "label" else NULL,
  expand.date = FALSE,
  ...
)
}
\arguments{
\item{data}{raw data from the API: A long format data frame where all values are stacked in a value column.}

\item{id_cols}{character. Temporal identifiers of the data. By default all variables in \code{\link{.SAMADB_T}} are selected.}

\item{names_from}{character. The column containing the series codes. These will become the names of the new columns in the wider data format.}

\item{values_from}{character. The column containing the data values.}

\item{labels_from}{character. The column containing the labels describing the series.}

\item{expand.date}{logical. \code{TRUE} will call \code{\link{sm_expand_date}} on the data after reshaping.}

\item{\dots}{further arguments passed to \code{\link[collapse]{pivot}} or \code{\link{sm_expand_date}}.}
}
\value{
A \code{\link[data.table]{data.table}} with the reshaped data.
}
\description{
This function automatically reshapes long (stacked) raw data from the API (\code{\link[=sm_data]{sm_data(..., wide = FALSE)}}) to a wide format where each variable has its own column.
Internally it uses \code{\link[collapse]{pivot}} from \emph{collapse}.
}
\examples{
\dontrun{
# Return all electricity indicators from the year 2000 onwards
sm_pivot_wider(sm_data("ELECTRICITY", from = 2000, wide = FALSE))
}
}
\seealso{
\code{\link{sm_pivot_longer}}, \code{\link{samadb}}
}
