% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_VI_estimate_G.R
\name{estimate_G}
\alias{estimate_G}
\alias{plot.SANvi_G}
\alias{summary.SANvi_G}
\alias{print.SANvi_G}
\title{Estimate the Atoms and Weights of the Discrete Mixing Distributions}
\usage{
estimate_G(object)

\method{plot}{SANvi_G}(x, DC_num = NULL, lim = 2, ...)

\method{summary}{SANvi_G}(object, thr = 0.01, ...)

\method{print}{SANvi_G}(x, thr = 0.01, ...)
}
\arguments{
\item{object}{an object of class \code{SANvi_G} (usually, the result of a call to \code{estimate_G}).}

\item{x}{an object of class \code{SANvi_G} (usually, the result of a call to \code{estimate_G}).}

\item{DC_num}{an integer or a vector of integers indicating which distributional clusters to plot.}

\item{lim}{optional value for the \code{plot} method to adjust the limits of the x-axis (the default is 2). The atoms are plotted on a range
given by \code{min(posterior means)-lim, max(posterior means)+lim}.}

\item{...}{ignored.}

\item{thr}{argument for the \code{print} method. It should be a small positive number,
representing a threshold. If the posterior weight of a specific shared atom is below the threshold, the
atom is not reported.}
}
\value{
The function \code{estimate_G} returns an object of class \code{SANvi_G}, which is a matrix comprising the posterior means,
variances, and weights of each estimated DC (one mixture component for each row).
}
\description{
The function computes the posterior means of the atoms and weights characterizing the discrete mixing distributions.
The function takes as input an object from \code{fit_CAM}, \code{fit_fiSAN},
or \code{fit_fSAN}, used with the \code{est_method = "VI"} argument, and returns an object of class \code{SANvi_G}.
}
\examples{
# Generate example data
set.seed(123)
y <- c(rnorm(100),rnorm(100,5))
g <- rep(1:2,rep(100,2))
plot(y,col=g)
# Fitting fiSAN via variational inference
est <- fit_fiSAN(y,g,vi_param= list(n_runs = 10))
est
summary(est)
# Estimate posterior atoms and weights
G <- estimate_G(est)
summary(G)
}
